﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.Models;
using PpmsDataWebService.ModelsEnumTypes;
using VA.PPMS.Context;
using Microsoft.Xrm.Client.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System.Diagnostics;
using Microsoft.Xrm.Sdk.Messages;

namespace PpmsDataWebService.Mappers
{
    public class CustomProviderMap
    {
        public static async Task<IQueryable<Provider>> MapProviders(List<Account> ppmsProviders,string queryType, IOrganizationService _service)
        {
            var providerList = new List<Provider> { };
            var context = new PpmsContext(await PpmsContextHelper.GetProxy());
            int count = 0;
            
            foreach (var ppmsProvider in ppmsProviders)
            {
                count += 1;                         
                var provider = new Provider
                {
                    ProviderIdentifier = Convert.ToInt64(ppmsProvider.ppms_ProviderIdentifier),
                    Name = ppmsProvider.Name,
                    MainPhone = ppmsProvider.Telephone1,
                    Email = ppmsProvider.EMailAddress1,                     
                    Address = ppmsProvider.Address1_Composite,
                    AddressCity = ppmsProvider.Address1_City,
                    AddressStreet = ppmsProvider.Address1_Line1,
                    AddressStateProvince = ppmsProvider.Address1_StateOrProvince,
                    AddressCounty = ppmsProvider.Address1_County,
                    AddressPostalCode = ppmsProvider.Address1_PostalCode,
                    AddressCountry = ppmsProvider.Address1_Country
                };

                //Provider Identifier Type
                if (ppmsProvider.ppms_ProviderIdentifierType != null)
                    switch (ppmsProvider.ppms_ProviderIdentifierType.Value)
                    {
                        case (int)ppms_ProviderIdentifierType.NPI:
                            provider.ProviderIdentifierType = ProviderIdentifierType.Npi;
                            break;
                            /*
                        case (int)ppms_ProviderIdentifierType.TaxIdentificationNumber:
                            provider.ProviderIdentifierType = ProviderIdentifierType.TaxIdentificationNumber;
                            break;
                            */
                    }


                if (ppmsProvider.ModifiedOn != null)
                {
                    provider.ModifiedOnDate = ppmsProvider.ModifiedOn.Value;
                }


                if (ppmsProvider.ppms_qualityrankingtotalscore != null)
                {
                    provider.QualityRankingTotalScore = (int)ppmsProvider.ppms_qualityrankingtotalscore;
                }

                //Internal/External Switch
                if (ppmsProvider.ppms_isexternal != null)
                    switch (ppmsProvider.ppms_isexternal.Value)
                    {
                        case true:
                            provider.IsExternal = true;
                            //External Attribute mappings

                            break;
                        case false:
                            provider.IsExternal = false;
                            //Internal Attribute mappings
             
                            break;
                    }

                //Provider Type Switch. 
                if (ppmsProvider.ppms_providertype != null)
                    switch (ppmsProvider.ppms_providertype.Value)
                    {
                        case (int)Account_ppms_providertype.Individual:
                            provider.ProviderType = ProviderType.Individual;

                            //Invidual Attribute Mappings
                                
                            //Accepting New Patients 
                            if (ppmsProvider.ppms_individualisacceptingnewpatients != null)
                                switch (ppmsProvider.ppms_individualisacceptingnewpatients.Value)
                                {
                                    case true:
                                        provider.IsAcceptingNewPatients = true;
                                        break;
                                    case false:
                                        provider.IsAcceptingNewPatients = false;
                                        break;
                                }

                                

                            //Gender
                            if (ppmsProvider.ppms_gender != null)
                                switch (ppmsProvider.ppms_gender.Value)
                                {
                                    case (int)ppms_Gender.Male:
                                        provider.ProviderGender = ProviderGender.Male;
                                        break;
                                    case (int)ppms_Gender.Female:
                                        provider.ProviderGender = ProviderGender.Female;
                                        break;
                                    case (int)ppms_Gender.NotSpecified:
                                        provider.ProviderGender = ProviderGender.NotSpecified;
                                        break;
                                    case (int)ppms_Gender.Other:
                                        provider.ProviderGender = ProviderGender.Other;
                                        break;
                                }

                            break;

                        case (int)Account_ppms_providertype.GroupPracticeAgency:
                            provider.ProviderType = ProviderType.GroupPracticeOrAgency;

                            //Group Org Attribute Mappings
                            provider.OrganizationId = ppmsProvider.ppms_organizationid;
                                
                            provider.OrganizationFax = ppmsProvider.Fax;

                            break;
                    }

                if (ppmsProvider.StatusCode != null)
                    switch (ppmsProvider.StatusCode.Value)
                    {
                        case (int)Account_StatusCode.Active:
                            provider.ProviderStatusReason = ProviderStatusReason.Active;
                            break;
                        case (int)Account_StatusCode.AddressValidation:
                            provider.ProviderStatusReason = ProviderStatusReason.AddressValidation;
                            break;
                        case (int)Account_StatusCode.Deactivated:
                            provider.ProviderStatusReason = ProviderStatusReason.Deactivated;
                            break;
                        case (int)Account_StatusCode.Hold:
                            provider.ProviderStatusReason = ProviderStatusReason.Hold;
                            break;
                        case (int)Account_StatusCode.Inactive:
                            provider.ProviderStatusReason = ProviderStatusReason.Inactive;
                            break;
                        case (int)Account_StatusCode.LEIEExclusion:
                            provider.ProviderStatusReason = ProviderStatusReason.LeieExclusion;
                            provider.OnLeie = true;
                            break;
                        case (int)Account_StatusCode.LicenseExpiration:
                            provider.ProviderStatusReason = ProviderStatusReason.LicenseExpiration;
                            break;
                        case (int)Account_StatusCode.NPICheckFailure:
                            provider.ProviderStatusReason = ProviderStatusReason.NpiCheckFailure;
                            break;
                        case (int)Account_StatusCode.PendingReview:
                            provider.ProviderStatusReason = ProviderStatusReason.PendingReview;
                            break;
                        case (int)Account_StatusCode.SAMSExclusion:
                            provider.ProviderStatusReason = ProviderStatusReason.SamsExclusion;
                            break;
                        case (int)Account_StatusCode.ValidationProcess:
                            provider.ProviderStatusReason = ProviderStatusReason.ValidationProcess;
                            break;

                    }

                if (ppmsProvider.ppms_PrimaryCarePhysician != null)
                    switch (ppmsProvider.ppms_PrimaryCarePhysician.Value)
                    {
                        case true:
                            provider.PrimaryCarePhysician = true;
                            break;
                        case false:
                            provider.PrimaryCarePhysician = false;
                            break;
                    }

                //Contact Methods
                //Contact Method Email? 
                if (ppmsProvider.ppms_ContactMethodEmail != null)
                    switch (ppmsProvider.ppms_ContactMethodEmail.Value)
                    {
                        case true:
                            provider.ContactMethodEmail = true;
                            break;
                        case false:
                            provider.ContactMethodEmail = false;
                            break;
                        default:
                            provider.ContactMethodEmail = false;
                            break;
                    }

                //Contact Method Fax? 
                if (ppmsProvider.ppms_ContactMethodFax != null)
                    switch (ppmsProvider.ppms_ContactMethodFax.Value)
                    {
                        case true:
                            provider.ContactMethodFax = true;
                            break;
                        case false:
                            provider.ContactMethodFax = false;
                            break;
                        default:
                            provider.ContactMethodFax = false;
                            break;
                    }

                //Contact Method Virtu Pro? 
                if (ppmsProvider.ppms_ContactMethodVirtuPro != null)
                    switch (ppmsProvider.ppms_ContactMethodVirtuPro.Value)
                    {
                        case true:
                            provider.ContactMethodVirtuPro = true;
                            break;
                        case false:
                            provider.ContactMethodVirtuPro = false;
                            break;
                        default:
                            provider.ContactMethodVirtuPro = false;
                            break;
                    }

                //Contact Method HSRM? 
                if (ppmsProvider.ppms_ContactMethodHSRM != null)
                    switch (ppmsProvider.ppms_ContactMethodHSRM.Value)
                    {
                        case true:
                            provider.ContactMethodHSRM = true;
                            break;
                        case false:
                            provider.ContactMethodHSRM = false;
                            break;
                        default:
                            provider.ContactMethodHSRM = false;
                            break;
                    }

                //Contact Method Phone? 
                if (ppmsProvider.ppms_ContactMethodPhone != null)
                    switch (ppmsProvider.ppms_ContactMethodPhone.Value)
                    {
                        case true:
                            provider.ContactMethodPhone = true;
                            break;
                        case false:
                            provider.ContactMethodPhone = false;
                            break;
                        default:
                            provider.ContactMethodPhone = false;
                            break;
                    }

                //Contact Method Mail? 
                if (ppmsProvider.ppms_PreferedContactMail != null)
                    switch (ppmsProvider.ppms_PreferedContactMail.Value)
                    {
                        case true:
                            provider.ContactMethodMail = true;
                            break;
                        case false:
                            provider.ContactMethodMail = false;
                            break;
                        default:
                            provider.ContactMethodMail = false;
                            break;
                    }

                //Contact Method Ref Doc? 
                if (ppmsProvider.ppms_ContactMethodRefDoc != null)
                    switch (ppmsProvider.ppms_ContactMethodRefDoc.Value)
                    {
                        case true:
                            provider.ContactMethodRefDoc = true;
                            break;
                        case false:
                            provider.ContactMethodRefDoc = false;
                            break;
                        default:
                            provider.ContactMethodRefDoc = false;
                            break;
                    }


                //Bulk Emailed allowed? 
                if (ppmsProvider.DoNotBulkEMail != null)
                    switch (ppmsProvider.DoNotBulkEMail.Value)
                    {
                        case true:
                            provider.BulkEmails = false;
                            break;
                        case false:
                            provider.BulkEmails = true;
                            break;
                    }

                //Bulk Mail allowed? 
                if (ppmsProvider.DoNotBulkPostalMail != null)
                    switch (ppmsProvider.DoNotBulkPostalMail.Value)
                    {
                        case true:
                            provider.BulkMails = false;
                            break;
                        case false:
                            provider.BulkMails = true;
                            break;
                    }

                //Email allowed? 
                if (ppmsProvider.DoNotEMail != null)
                    switch (ppmsProvider.DoNotEMail.Value)
                    {
                        case true:
                            provider.Emails = false;
                            break;
                        case false:
                            provider.Emails = true;
                            break;
                    }

                //Mail allowed?
                if (ppmsProvider.DoNotPostalMail != null)
                    switch (ppmsProvider.DoNotPostalMail.Value)
                    {
                        case true:
                            provider.Mails = false;
                            break;
                        case false:
                            provider.Mails = true;
                            break;
                    }

                //Phone allowed?
                if (ppmsProvider.DoNotPhone != null)
                    switch (ppmsProvider.DoNotPhone.Value)
                    {
                        case true:
                            provider.PhoneCalls = false;
                            break;
                        case false:
                            provider.PhoneCalls = true;
                            break;
                    }

                //Faxes allowed? 
                if (ppmsProvider.DoNotFax != null)
                    switch (ppmsProvider.DoNotFax.Value)
                    {
                        case true:
                            provider.Faxes = false;
                            break;
                        case false:
                            provider.Faxes = true;
                            break;
                    }


                //Check for Expand QueryTypes here:
                //Provider Services
                if (queryType.Contains("ProviderServices") || queryType.Contains("providerservices"))
                {
                    //Every 20,000 get new CRM ORg Service
                    if (count % 20000 == 0) { context = new PpmsContext(await PpmsContextHelper.GetProxy()); }
                    var ppmsProviderServices = context.ppms_providerserviceSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id).ToList();

                    if (ppmsProviderServices.Any())
                    {
                        provider.ProviderServices = await ProviderServicesMap.MapProviderServices(ppmsProviderServices, "none", context);
                    }                  
                }

                //Provider Specialties
                if (queryType.Contains("ProviderSpecialties") || queryType.Contains("providerspecialties"))
                {
                    //Every 20,000 get new CRM ORg Service
                    if (count % 20000 == 0) { context = new PpmsContext(await PpmsContextHelper.GetProxy()); }
                    var ppmsProviderSpecialties = context.ppms_providertaxonomySet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id).ToList();

                    if (ppmsProviderSpecialties.Any())
                    {
                        provider.ProviderSpecialties = await ProviderSpecialtyMap.MapProviderSpecialties(ppmsProviderSpecialties, "none", context);
                    }
                }
                
                //Provider Identifiers
                if (queryType.Contains("ProviderIdentifiers") || queryType.Contains("provideridentifiers"))
                {
                    //Every 20,000 get new CRM ORg Service
                    if (count % 20000 == 0) { context = new PpmsContext(await PpmsContextHelper.GetProxy()); }
                    var ppmsProviderIdentifiers = context.ppms_provideridentifierSet.Where(i => i.ppms_Provider.Id == ppmsProvider.Id).ToList();

                    if (ppmsProviderIdentifiers.Any())
                    {
                        provider.ProviderIdentifiers = await ProviderIdentifiersMap.MapProviderIdentifiers(ppmsProviderIdentifiers, "none", context);
                    }
                }

                //VA Provider Relationships
                if (queryType.Contains("VaProviderRelationships") || queryType.Contains("vaproviderrelationships"))
                {
                    //Every 20,000 get new CRM ORg Service
                    if (count % 20000 == 0) { _service = await PpmsContextHelper.GetProxy(); }



                }






                providerList.Add(provider);
                
            }
            
            var provs = providerList.AsQueryable();
            return provs;
        }

    }
}